# eng38.inc
# scenario file for 1938 scenario
# Created by Andrew S. Davidson on 8 March 2005
# amended 20 Mar 2005 - peacetime_ic_mod added at high level and some OoB tweaks.
# 17-Sep-05 - reduce AA some more (they actually had lots in UK but AA is too good currently in the game)
#           - remove guarantees from 1939
#           - reduce manpower to 200 from 400
# 1 Oct-05  - reduce manpower to 100 to keep army small and make Cyprus national territory (along with Turkish/Greek claims)

province = { id =    9 ic = 4 } # Glasgow
province = { id =   10 ic = 3 } # Edinburgh
province = { id =   11 ic = 3 } # Sunderland
province = { id =   12 ic = 2 } # Blackpool
province = { id =   13 ic = 5 } # Sheffield
province = { id =   14 ic = 6 } # Liverpool
province = { id =   16 ic = 6 } # Birmingham
province = { id =   19 ic = 6 } # London
province = { id = 1465 ic = 2 } # Rajkot
province = { id = 1469 ic = 9 } # Delhi
province = { id = 1478 ic = 2 } # Bikaner
province = { id = 1479 ic = 3 } # Jodhpur
province = { id = 1505 ic = 2 } # Bombay
province = { id = 1513 ic = 2 } # Mangalore

province = { id = 20	landfort = 0 coastalfort = 3 }	#Dover
province = { id = 31	landfort = 0 coastalfort = 3 }	#Malta (has cliffs all around)
province = { id = 348	landfort = 6 coastalfort = 0 }	#Gibraltar
province = { id = 1315	landfort = 3 coastalfort = 1 }	#Hong Kong
province = { id = 1517	landfort = 0 coastalfort = 2 }	#Ceylon
province = { id = 1353	landfort = 0 coastalfort = 3 }	#Singapore

province = { id = 5	anti_air = 1 } #Scapa Flow
province = { id = 9	anti_air = 1 } #Glasgow
province = { id = 10	anti_air = 1 } #Edinburgh
province = { id = 11	anti_air = 1 } #Sunderland
province = { id = 12	anti_air = 1 } #Blackpool
province = { id = 13	anti_air = 1 } #Sheffield
province = { id = 14	anti_air = 1 } #Liverpool
province = { id = 15	anti_air = 1 } #Cardiff
province = { id = 16	anti_air = 1 } #Birmingham
province = { id = 17	anti_air = 1 } #Norwich
province = { id = 19  	anti_air = 2 } #London
province = { id = 20  	anti_air = 2 } #Dover
province = { id = 21	anti_air = 2 } #Portsmouth
province = { id = 22	anti_air = 1 } #Bristol
province = { id = 23	anti_air = 2 } #Plymouth
province = { id = 31	anti_air = 1 } #Malta
province = { id = 348	anti_air = 1 } #Gibraltar
province = { id = 900	anti_air = 1 } #Suez
province = { id = 906	anti_air = 1 } #Alexandria
province = { id = 1315	anti_air = 1 } #Hong Kong
province = { id = 1353	anti_air = 1 } #Singapore
province = { id = 1517	anti_air = 1 } #Colombo


province = { id = 5  radar_station = {  size = 1  current_size = 1  } } #Scapa Flow
province = { id = 9  radar_station = {  size = 1  current_size = 1  } } #Glasgow
province = { id = 10 radar_station = {  size = 1  current_size = 1  } } #Edinburgh
province = { id = 11 radar_station = {  size = 1  current_size = 1  } } #Sunderland
province = { id = 13 radar_station = {  size = 1  current_size = 1  } } #Sheffield
province = { id = 17 radar_station = {  size = 1  current_size = 1  } } #Norwich
province = { id = 20 radar_station = {  size = 2  current_size = 2  } } #Dover
province = { id = 21 radar_station = {  size = 1  current_size = 1  } } #Portsmouth

# Scapa Flow
province = { id = 5	air_base = { size = 2 current_size = 2	}
			naval_base = { size = 10 current_size = 10 } }
# Glasgow
province = { id = 9	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 10 current_size = 10 } }
# Sunderland
province = { id = 11	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 6	current_size = 6 } }
# Sheffield
province = { id = 13	air_base = { size = 4 current_size = 4 }
			naval_base = { size = 2 current_size = 2 } }
# Liverpool
province = { id = 14	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 6 current_size = 6 } }
# Birmingham
province = { id = 16	air_base = { size = 4 current_size = 4 } }

# Norwich
province = { id = 17	air_base = { size = 8 current_size = 8 }
			naval_base = { size = 1 current_size = 1 } }
# London
province = { id = 19	air_base = { size = 4 current_size = 4 } }

# Dover
province = { id = 20	air_base = { size = 8 current_size = 8 }
			naval_base = { size = 4 current_size = 4 } }
# Portmouth
province = { id = 21	air_base = { size = 4 current_size = 4 }
			naval_base = { size = 10 current_size = 10 } }
# Plymouth
province = { id = 23	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 10 current_size = 10 } }
# Belfast
province = { id = 28	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 4 current_size = 4 } }
# Malta
province = { id = 31	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 6	current_size = 6 } }
# Gibraltar
province = { id = 348	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 6 current_size = 6 } }
# Cyprus 
province = { id = 444	air_base = { size = 1 current_size = 1 } }

#Bermuda
province = { id = 538	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 1 current_size = 1 } }
# Andros
province = { id = 652	air_base = { size = 1 current_size = 1 } }

# Falklands
province = { id = 866	naval_base = { size = 1	current_size = 1 } }

# Georgetown
province = { id = 873	air_base = { size = 1 current_size = 1 } }

# Alexandria
province = { id = 906	air_base = { size = 4 current_size = 4 }
			naval_base = { size = 10 current_size = 10 } }
# Freetown
province = { id = 988	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 2	current_size = 2 } }
# Accra
province = { id = 1002	air_base = { size = 1 current_size = 1 } }

# Lagos
province = { id = 1008	air_base = { size = 1 current_size = 1 } }

# Mombasa
province = { id = 1061	air_base = { size = 1 current_size = 1 } }

# Khartoum
province = { id = 1066	air_base = { size = 1 current_size = 1 } }

# Mandalay
province = { id = 1296	air_base = { size = 1 current_size = 1 } }

#Rangoon
province = { id = 1299	air_base = { size = 1	current_size = 1 }
			naval_base = { size = 6 current_size = 6 } }
# Hong Kong
province = { id = 1315	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 6 current_size = 6 } }
# Singapore
province = { id = 1353	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 10 current_size = 10 } }
# Calcutta
province = { id = 1457	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 6 current_size = 6 } }
# Indore
province = { id = 1467	air_base = { size = 1 current_size = 1 } }

# Delhi
province = { id = 1469	air_base = { size = 2 current_size = 2 } }

# Karachi
province = { id = 1494	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 6	current_size = 6 } }
#Bombay
province = { id = 1505	air_base = { size = 2	current_size = 2 }
			naval_base = { size = 6 current_size = 6 } }
# Cochin
province = { id = 1514	air_base = { size = 1 current_size = 1 } }

# Trincomalee
province = { id = 1516	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 2 current_size = 2 } } 
#Columbo
province = { id = 1517	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 6 current_size = 6 } }
# Kuching
province = { id = 1644	air_base = { size = 1 current_size = 1 } }

# Tel Aviv
province = { id = 1798	air_base = { size = 1 current_size = 1 } }

# Aden
province = { id = 1813	naval_base = { size = 1 current_size = 1 } }

#Diego Garcia
province = { id = 1817	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 1 current_size = 1 } }

province = {  id = 1100		oilpool = 100	supplypool = 500 }	# Egypt (Port Said)
province = {  id = 1459		oilpool = 100	supplypool = 500 }	# India (Bombay)
province = {  id = 348		oilpool = 200	supplypool = 500 }	# Gibraltar
province = {  id = 1353		oilpool = 1000	supplypool = 5000 }	# Singapore
province = {  id = 31		oilpool = 100	supplypool = 500 }	# Malta
province = {  id = 1315		oilpool = 100	supplypool = 500 }	# Hong Kong
province = {  id = 1517		oilpool = 1000	supplypool = 2000 }	# Ceylon
province = {  id = 538		oilpool = 100	supplypool = 500 }	# Bermuda
province = {  id = 988		oilpool = 1000	supplypool = 2000 }	# Freetown
province = {  id = 28		oilpool = 1000	supplypool = 2000 }	# Belfast
province = {  id = 866		oilpool = 100	supplypool = 200 }	# Falklands
province = {  id = 1817		oilpool = 100	supplypool = 200 }	# Diego Garcia

country = { tag = ENG
	capital = 19
	policy = { date = { year = 0 month = january day = 0 }
	        democratic		= 10
        	political_left		= 2
	        freedom			= 9
        	free_market		= 8
	        professional_army	= 8 # no conscription
        	defense_lobby		= 6
	        interventionism 	= 6
	    	}

	headofstate		= { type = 9 id = 1033 }
	headofgovernment	= { type = 9 id = 1037 }
 	foreignminister		= { type = 9 id = 1003 }
 	armamentminister	= { type = 9 id = 1163 }
 	ministerofsecurity	= { type = 9 id = 1083 }
 	ministerofintelligence	= { type = 9 id = 1006 }
 	chiefofstaff		= { type = 9 id = 1117 }
 	chiefofarmy		= { type = 9 id = 1128 }
 	chiefofnavy		= { type = 9 id = 1137 }
 	chiefofair		= { type = 9 id = 1149 }

	dormant_ministers = { 1001 1031 1002 1004 1081 1007 1008 1127 1009 1010 1082 }

	peacetime_ic_mod = 0.4  # 1938 expenditure on war was actually less than one sixth of the level once war started
				# this level allows the capital naval program to be fully built but little else
				# this may help stop UK starting the war with a huge army, which upsets people
	energy		= 10000   
	oil		= 10000	
	manpower	= 100
	metal		= 10000		
	money		= 1000
	rare_materials	= 10000	
	supplies	= 1000
	transports 	= 1200
	escorts 	= 150

	ai = "ENG_1936.ai"

	ownedprovinces =      {
		# GREAT BRITAIN
		3 5 6 7 8 9 10 11 12 13 14 15 16 17 19 20 21 22 23
		575 576	# Newfoundland
		28 29	# N.Ireland
		348	# Gibraltar
		31	# Malta
		444	# Cyprus
		# INDIA
		1494 1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477 1877 1878
		1469 1470 1471 1472 1456 1468 1467 1464 1463 1474
		1460 1459 1457 1458 1461 1508 1462 1505 1506 1507 1509 1510
		1511 1512 1513 1514 1515 1516 1517 1518 1519 1284 1285
		1286 1287 1288 1289 1290 1291 1898 1304 1295 1296
		1301 1302 1346 1299 1298 1297 1300 1292 1454
		# MIDDLE-EAST
		1799 1798 1797 1796 404 1802 1803 406 407
		1813 1814	# Aden Protectorate
		1504 1820	# Trucial States
		# SOUTHEAST ASIA
		1349 1350 1351 1352 1353 # Malay States
		1644 1646 1647		 # Sarawak-Borneo
		1315			 # Hong Kong
		# CARRIBEAN
		758 			# Belize
		891 			# Jamaica
		871 873 		# Br.Guyana
		806 807 808 809 897 	# Br. West Indies
		538 			# Bermuda
		652 653 664 665 666 668 # The Bahamas
		805			# St.Lucia
		896			# Virgin Islands
		# MISC
		866  			# Falklands
		1147 			# Ascension
		1148 			# St.Helena
		1816 			# Seychelles
		1817 			# Diego Garcia
		1136 			# Mauritius
		1815 			# Sokotra
		# EAST AFRICA
		1132 			# Malawi
		1139 1062 1140 1141 1064 1060 1061 1059 #Br.East Africa
		1035 1036 		# Br.Somaliland
		# SOUTH AFRICA
		1112 1111 1105 		# Bechuanaland
		1124 1125 		# South Rhodesia
		1104 1099 1129 1126 1128 # North Rhodesia
		# WEST AFRICA
		1000 1001 1002		# Gold Coast
		1008 1007 999 1009 1010 1011 1145 1085 1012 # Nigeria
		988 			# Sierra Leone
		982 			# Gambia
		# PACIFIC
		1622 1683 1684 1685 1686
		1763
		1761 1767 1768 1769 1770
		1757 1759 1760
		1752 1753 1754 1755 1758
		#EGYPT
		900 901 902 903 904 905 906 907 908 909 910 911 912 913 914 915
		4 1020 1019 1021 1022 1027 1023 1026 1024 1025 1800 1801
		#SUDAN
		1065 1066 1069 1068 1067 1029 1028 1032 1031 1030 1040 1041
		1614 1611
	}

	controlledprovinces = {
		#GREAT BRITAIN
		3 5 6 7 8 9 10 11 12 13 14 15 16 17 19 20 21 22 23
		575 576 #Newfoundland
		28 29 #N.Ireland
		348 #Gibraltar
		31 #Malta
		444 #Cyprus
		#INDIA
		1494 1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477  1877  1878
		1469 1470 1471 1472 1456 1468 1467 1464 1463 1474
		1460 1459 1457 1458 1461 1508 1462 1505 1506 1507 1509 1510
		1511 1512 1513 1514 1515 1516 1517 1518 1519 1284 1285
		1286 1287 1288 1289 1290 1291 1898 1304 1295 1296
		1301 1302 1346 1299 1298 1297 1300 1292 1454
		#MIDDLE-EAST
		1799 1797 1796 404 1802 1803 406 407
		1813 1814 #Aden Protectorate
		1504 1820#Trucial States
		1798
		#SOUTHEAST ASIA
		1349 1350 1351 1352 1353 #Malay States
		1644 1646 1647 #Sarawak-Borneo
		1315 #Hong Kong
		# CARRIBEAN
		758 #Belize
		891 #Jamaica
		871 873 #Br.Guyana
		806 807 808 809 897 #Br. West Indies
		538 #Bermuda
		652 653 664 665 666 668 #The Bahamas
		805
		896
		# MISC
		866  #Falklands
		1147 #Ascension
		1148 #St.Helena
		1816 #Seychelles
		1817 #Diego Garcia
		1136 #Mauritius
		1815 # Sokotra
		# EAST AFRICA
		1139 1062 1140 1141 1064 1060 1061 1059 #Br.East Africa
		1132 #Malawi
		1035 1036 #Br.Somaliland
		# SOUTH AFRICA
		1112 1111 1105 #Bechuanaland
		1124 1125 #South Rhodesia
		1104 1099 1129 1126 1128 #North Rhodesia
		# WEST AFRICA
		1000 1001 1002 #Gold Coast
		1008 1007 999 1009 1010 1011 1145 1085 1012 #Nigeria
		988 #Sierra Leone
		982 #Gambia
		# PACIFIC
		1622 1683 1684 1685 1686
		1763
		1761 1767 1768 1769 1770
		1757 1759 1760
		1752 1753 1754 1755 1758
		#EGYPT
		900 901 902 903 904 905 906 907 908 909 910 911 912 913 914 915

		4 1020 1019 1021 1022 1027 1023 1026 1024 1025 1800 1801
		#SUDAN
		1065 1066 1069 1068 1067 1029 1028 1032 1031 1030 1040 1041
		1614 1611
				}

	nationalprovinces =   {
		#GREAT BRITAIN
		3 5 6 7 8 9 10 11 12 13 14 15 16 17 19 20 21 22 23
		28 29 	# N.Ireland
		348	# Gibraltar
		31 	# Malta
		444	# Cyprus - annexed by the British Empire in 1913 and UK still has sovereign bases there
		#INDIA
		1494 1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477  1877  1878
		1469 1470 1471 1472 1456 1468 1467 1464 1463 1474
		1460 1459 1457 1458 1461 1508 1462 1505 1506 1507 1509 1510
		1511 1512 1513 1514 1515 1516 1517 1518 1519 1284 1285
		1286 1287 1288 1289 1290 1291 1898 1304 1295 1296
		1301 1302 1346 1299 1298 1297 1300 1292 1454
				}

diplomacy = {
relation = { tag = AFG value = -75 }
relation = { tag = ARG value = 75 }
relation = { tag = AST value = 200 }
relation = { tag = BEL value = 150 }
relation = { tag = BHU value = 200}
relation = { tag = BUL value = 20 }
relation = { tag = CAN value = 200 }
relation = { tag = CHI value = 100 }
relation = { tag = CZE value = 50 }
relation = { tag = DEN value = 100 }
relation = { tag = EST value = 50 }
relation = { tag = FIN value = 85 }
relation = { tag = FRA value = 150 }
relation = { tag = GER value = -100 }
relation = { tag = GRE value = 50 }
relation = { tag = GUA value = 50 }
relation = { tag = HOL value = 125 }
relation = { tag = HUN value = 0 }
relation = { tag = IRE value = 50 }
relation = { tag = IRQ value = 100 access = yes guaranteed = { day = 11 month = february year = 1930 }}
relation = { tag = ITA value = -50 }
relation = { tag = JAP value = -50 }
relation = { tag = MEX value = 50 }
relation = { tag = NEP value = 200 }
relation = { tag = NOR value = 90 }
relation = { tag = NZL value = 200 }
relation = { tag = OMN value = 150 }
relation = { tag = PER value = 25 }
relation = { tag = POL value = 100 }
relation = { tag = POR value = 100 }
relation = { tag = ROM value = 50  }
relation = { tag = SAF value = 200 }
relation = { tag = SAU value = 100 guaranteed = { day = 11 month = february year = 1934 } }
relation = { tag = SCH value = 50   }
relation = { tag = SIA value = 70 }
relation = { tag = SOV value = -100 }
relation = { tag = SPA value = -50 }
relation = { tag = SPR value = 0 }
relation = { tag = SWE value = 80 }
relation = { tag = TUR value = 75  guaranteed = { day = 17 month = may year = 1938 } }
relation = { tag = USA value = 100 }
relation = { tag = VEN value = -10 }
relation = { tag = YEM value = 150 guaranteed = { day = 11 month = february year = 1934 } }

}

techapps = {
1010 # Great War Infantry
1020 # Early Infantry
1110 # Basic Mountain
1150 # Basic Marine
1190 # Great War Cavalry Division
1200 # Early Cavalry Division
1210 # Basic Cavalry Division
1220 # Semi-motorised Cavalry
1230 # Basic Motorized Infantry
1310 # Rear Area Supply Dumps
1340 # Rear Area Vehicle Repair Shop
2010 # Great War Tank
2020 # Tankette
2030 # Early Tank
2040 # Basic Light Tank
2150 # Basic Armoured Car
2290 # Great War Light Field Artillery
2300 # Great War Medium Field Artillery
2310 # Great War Heavy Field Artillery
2320 # Early Field Artillery
2330 # Basic Artillery
2400 # Basic AT
2450 # Great War Static Anti-Air Artillery
2460 # Early Static AA
2510 # Basic AA
3010 # Great War Destroyer
3020 # Early Destroyer
3030 # Basic Destroyer
3070 # Great War Light Cruiser
3080 # Early Light Cruiser
3090 # Basic Light Cruiser
3100 # Improved Light Cruiser
3130 # Great War Heavy Cruiser
3140 # Early Heavy Cruiser
3150 # Basic Heavy Cruiser
3190 # Great War Battlecruiser
3200 # Early Battlecruiser
3210 # Basic Battlecruiser
3250 # Great War Battleship
3260 # Early Battleship
3270 # Basic Battleship
3280 # Improved Battleship
3320 # Great War Air Carrier
3330 # Early Air Carrier
3340 # Basic Air Carrier
3350 # Imp. Air Carrier
3400 # Dive Boat
3410 # Short Range Submarine
3420 # Medium Range Submarine
4010 # Interwar Fighter
4020 # Early Fighter
4030 # Basic Interceptor
4120 # Interwar Bomber
4130 # Early Bomber
4140 # Basic Tactical Bomber
4190 # Basic Naval Bomber
4220 # Basic Strategic Bomber
5010 # Modern Agriculture
5020 # Mechanized Agriculture
5030 # Agrichemistry
5050 # Basic Machine Tools
5080 # Basic Construction Engineering
5090 # Improved Construction Engineering
5190 # Basic Oil Refining
5200 # Improved Oil Refining
5310 # Census Tabulating Machine
5320 # Basic Computing Machine
5350 # Basic Encryption Devices
5360 # Basic Decryption Devices
5410 # Basic Decimetric Radar Warning Sites
5470 # Faculty of Atomic Research
5480 # Atomic Research Laboratories
5490 # Faculty of Nuclear Research
6010 # Firepower Focus Doctrine
6030 # Grand Battle Plan Doctrine
6110 # Mass Assault Doctrine
6120 # Trench Warfare Doctrine
8010 # Decisive Battle Doctrine
8020 # Naval Firepower Doctrine
8030 # Fleet Auxiliary Carrier Doctrine
8040 # Fleet Auxiliary Submarine Doctrine
8050 # Convoy Sailing Doctrine
8070 # Fleet-in-Being Doctrine
8120 # Battlefleet Concentration Doctrine
8310 # Floating Fortress Doctrine
9010 # Air Superiority Doctrine
9020 # Flying Circus Doctrine
9030 # Force Substitution Doctrine
9090 # Operational Destruction Doctrine
9140 # Strategic Destruction Doctrine
	}

landunit = { location = 22  id = { type = 13016 id = 1 }	name = "Ф˾ "
		division = { experience = 35 id = { type = 13016 id = 1111 }	name = "½˾ "
				type = hq strength  = 100 model = 1 }
		division = { experience = 20 id = { type = 13016 id = 2 } name = "1ʦ "
				type = infantry strength = 80 model = 2	extra = anti_air brigade_model = 1}
		division = { experience = 20 id = { type = 13016 id = 3 } name = "2ʦ "
				type = infantry	strength = 80 model = 2 extra = engineer } }

landunit = { location = 20 id = { type = 13016 id = 4 }		name = "˾ -  "
		division = { experience = 20 id = { type = 13016 id = 5 }	name = "4ʦ "
				type = infantry	strength = 75 model = 1 extra = artillery brigade_model = 2} }

landunit = { location = 17 id = { type = 13016 id = 54 }		name = "˾ - ³ "
		division = { experience = 20 id = { type = 13016 id = 6 }	name = "12''ʦ "
				type = garrison strength = 50 model = 0 locked = yes}
		division = { experience = 20 id = { type = 13016 id = 9 }	name = "54'³'ʦ "
				type = garrison	strength = 50 model = 0 } }

landunit = { location = 20 id = { type = 13016 id = 55 }		name = "˾ -  "
		division = { experience = 20 id = { type = 13016 id = 7 }	name = "18ʦ "
				type = garrison	strength = 60 model = 0 extra = anti_air brigade_model = 1}
		division = { experience = 15 id = { type = 13016 id = 8 }	name = "44''ʦ "
				type = garrison	strength = 50 model = 0 locked = yes} }

landunit = { location = 19 id = { type = 13016 id = 10 }	name = "׶ص "
		division = { experience = 35 id = { type = 13016 id = 11 }	name = "47'׶'ʦ "
				type = garrison strength = 60 model = 0 extra = artillery brigade_model = 2}
		division = { experience = 35 id = { type = 13016 id = 12 }	name = "56'׶'ʦ "
				type = garrison	strength = 50 model = 0 locked = yes} }

landunit = { location = 11 id = { type = 13016 id = 13 } 	name = "˾ -  "
		division = { experience = 20 id = { type = 13016 id = 14 }	name = "5ʦ "
				type = infantry	strength = 70 model = 1 extra = artillery brigade_model = 2} }

landunit = { location = 11 id = { type = 13016 id = 51 } 	name = "˾ - ŦԼ "
		division = { experience = 15 id = { type = 13016 id = 15 }	name = "49''ʦ "
				type = garrison	strength = 50 model = 0 locked = yes extra = engineer } }

landunit = { location = 13 id = { type = 13016 id = 52} 	name = "˾ - Լ "
		division = { experience = 15 id = { type = 13016 id = 16 }	name = "46'׵'ʦ "
				type = garrison	strength = 50 model = 0 locked = yes extra = anti_air brigade_model = 1} }

landunit = { location = 12 id = { type = 13016 id = 53 } 	name = "˾ - ߽ "
		division = { experience = 20 id = { type = 13016 id = 17 }	name = "23'ŵɭ'ʦ "
				type = garrison	strength = 50 model = 0 }
		division = { experience = 20 id = { type = 13016 id = 18 }	name = "50'ŵɭ'ʦ "
				type = garrison	strength = 50 model = 0 locked = yes} }

landunit = { location = 9 id = { type = 13016 id = 19 }		name = "ո˾ -  "
		division = { experience = 35 id = { type = 13016 id = 20 }	name = "9'ո'ʦ "
				type = garrison strength = 50 model = 0 locked = yes extra = artillery brigade_model = 2}}

landunit = { location = 10 id = { type = 13016 id = 50 }		name = "ո˾ -  "
		division = { experience = 45 id = { type = 13016 id = 21 }	name = "51'ߵ'ʦ "
				type = garrison strength = 70 model = 0 locked = yes extra = engineer} }

landunit = { location = 21 id = { type = 13016 id = 22 }	name = "ϲ˾ -  "
		division = { experience = 20 id = { type = 13016 id = 23 }	name = "3ʦ "
				type = infantry	strength = 75 model = 1 extra = engineer}
		division = { experience = 15 id = { type = 13016 id = 24 }	name = "1װʦ "
				type = light_armor strength = 10 model = 0 } }

landunit = { location = 22 id = { type = 13016 id = 58 }	name = "ϲ˾ - ׵ "
		division = { experience = 15 id = { type = 13016 id = 25 }	name = "48'׵'ʦ "
				type = garrison strength = 60 locked = yes model = 0 } }

landunit = { location = 23 id = { type = 13016 id = 59 }	name = "ϲ˾ -  "
		division = { experience = 15 id = { type = 13016 id = 27 }	name = "43'˹'ʦ "
				type = garrison	strength = 50 model = 0 locked = yes extra = anti_air brigade_model = 1} }

landunit = { location = 21 id = { type = 13016 id = 60 }	name = "ϲ˾ -  "
		division = { experience = 10 id = { type = 13016 id = 26 }	name = "61ʦ "
				type = garrison	strength = 50 model = 0 extra = artillery brigade_model = 2}
		division = { experience = 15 id = { type = 13016 id = 28 }	name = "45ʦ "
				type = garrison	strength = 50 model = 0 locked = yes} }

landunit = { location = 14 id = { type = 13016 id = 29 } 	name = "˾ - ˹ "
		division = { experience = 15 id = { type = 13016 id = 30 }	name = "55''ʦ "
				type = garrison strength = 50 model = 0 extra = anti_air brigade_model = 1}
		division = { experience = 15 id = { type = 13016 id = 31 }	name = "42''ʦ "
				type = garrison strength = 50 model = 0 locked = yes extra = artillery brigade_model = 2} }

landunit = { location = 15 id = { type = 13016 id = 56 } 	name = "˾ - ʿ "
		division = { experience = 15 id = { type = 13016 id = 33 }	name = "38'ʿ'ʦ "
				type = garrison	strength = 50 model = 0 }
		division = { experience = 15 id = { type = 13016 id = 34 }	name = "53'ʿ'ʦ "
				type = garrison	strength = 50 model = 0	} }

landunit = { location = 16 id = { type = 13016 id = 57 } 	name = "˾ - ׵ "
		division = { experience = 15 id = { type = 13016 id = 32 }	name = "66ʦ "
				type = garrison	strength = 50 model = 0 } }

landunit = { location = 1007 id = { type = 13016 id = 424 } 	name = "ʼǰ߲ "
		division = { experience = 15 id = { type = 13016 id = 425 }	name = "-Ա-ƽ𺣰 "
				type = bergsjaeger	strength = 30  } } # light infantry with african porters not mules

landunit = { location = 1315 id = { type = 13016 id = 35 }	name = "˾ "
		division = { experience = 35 id = { type = 13016 id = 36 }	name = "۷ "
				type = garrison	model = 0 strength = 100 locked = yes extra = artillery brigade_model = 2} }

landunit = { location = 1353 id = { type = 13016 id = 37 }			name = "˾ "
		division = { experience = 35 id = { type = 13016 id = 38 }	name = "¼· "
				type = garrison	model = 0 strength = 100 locked = yes extra = anti_air brigade_model = 1} }

landunit = { location = 348  id = { type = 13016 id = 39 }	name = "ֱ˾ "
		division = { experience = 45 id = { type = 13016 id = 40 }	name = "ֱӷ "
				type = garrison	model = 0 strength = 100 locked = yes extra = artillery brigade_model = 2} }

landunit = { location = 31 id = { type = 13016 id = 41 }	name = "˾ "
		division = { experience = 35 id = { type = 13016 id = 42 }	name = " "
				type = garrison	model = 0 strength = 100 locked = yes extra = artillery brigade_model = 2} }

landunit = { location = 1517 id = { type = 13016 id = 43 }	name = "˾ "
		division = { experience = 35 id = { type = 13016 id = 44 }	name = " "
				type = garrison	locked = yes model = 0 strength = 100 } }

landunit = { location = 538 id = { type = 13016 id = 45 }	name = "Ľ˾ "
		division = { experience = 35 id = { type = 13016 id = 46 }	name = "Ľ־Ըǹ "
				type = garrison	locked = yes strength = 100 model = 0} }

landunit = { location = 911 id = { type = 13016 id = 47 }	name = "ж˾ "
		division = { experience = 15 id = { type = 13016 id = 48 }	name = "7Ħлʦ "
				type = motorized strength = 50 model = 0
				extra = artillery brigade_model = 3 }
		division = { experience = 35 id = { type = 13016 id = 49}	name = "װʦ "
				type = light_armor strength = 50 model = 0 } }

landunit = { location = 1483 id = { type = 13016 id = 300 }	name = "ɳ߾ "
		division = { experience = 40 id = { type = 13016 id = 301 }	name = "1ǹ "
				type = bergsjaeger strength = 100 model = 0 } }

landunit = { location = 1474 id = { type = 13016 id = 302 }	name = "߶Ʒھ "
		division = { experience = 40 id = { type = 13016 id = 303 }	name = "2ǹ "
				type = bergsjaeger strength = 100 model = 0 } 
		division = { experience = 40 id = { type = 13016 id = 304 }	name = "3ǹ "
				type = bergsjaeger strength = 100 model = 0 } }

landunit = { location = 1475 id = { type = 13016 id = 305 }	name = "϶ "
		division = { experience = 25 id = { type = 13016 id = 306 }	name = "ʼ "
				type = cavalry strength  = 100 model = 1 
                                extra = armored_car brigade_model = 0 } }

landunit = { location = 1482 id = { type = 13016 id = 307 }	name = "˹̹ "
		division = { experience = 25 id = { type = 13016 id = 308 }	name = " "
				type = infantry	strength  = 100 model = 0 } }

landunit = { location = 1477 id = { type = 13016 id = 309 }	name = "ؾ "
		division = { experience = 25 id = { type = 13016 id = 310 }	name = "߶ǹ "
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1471 id = { type = 13016 id = 311 }	name = "տ觾 "
		division = { experience = 25 id = { type = 13016 id = 312 }	name = " "
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1457 id = { type = 13016 id = 313 }	name = "ֱϽ "
		division = { experience = 25 id = { type = 13016 id = 314 }	name = "ķǹ "
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1506 id = { type = 13016 id = 315 }	name = "ǵ "
		division = { experience = 25 id = { type = 13016 id = 316 }	name = "ɲǹ "
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1505 id = { type = 13016 id = 317 }	name = " "
		division = { experience = 25 id = { type = 13016 id = 318 }	name = "Ჽ "
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1511 id = { type = 13016 id = 319 }	name = "˹ "
		division = { experience = 25 id = { type = 13016 id = 320 }	name = " "
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1066 id = { type = 13016 id = 400 }	name = "յ " 
		division = { experience = 10 id = { type = 13016 id = 401 }	name = "յͰ "
				type = cavalry strength = 30 model = 0} }

landunit = { location = 1813 id = { type = 13016 id = 402 }	name = "Ƕ " 
		division = { experience = 10 id = { type = 13016 id = 403 }	name = "ϣѵ "
				type = garrison locked = yes strength = 30 }	}

landunit = { location = 1035 id = { type = 13016 id = 404 }	name = " "
		division = { experience = 10 id = { type = 13016 id = 405 }	name = "վ "
				type = cavalry strength = 10 model = 0} }

landunit = { location = 1060 id = { type = 13016 id = 406 }	name = "ڸɴؾ "
		division = { experience = 10 id = { type = 13016 id = 407 }	name = "1޲ǹ "
				type = militia strength = 10 }	}

landunit = { location = 1062 id = { type = 13016 id = 410 }	name = " "
		division = { experience = 10 id = { type = 13016 id = 411 }	name = "2޲ǹ "
				type = militia strength = 100 }	}

landunit = { location = 1140 id = { type = 13016 id = 412 }	name = " "
		division = { experience = 10 id = { type = 13016 id = 413 }	name = "3޲ǹ "
				type = militia strength = 100 }	}

landunit = { location = 1139	id = { type = 13016 id = 414 }	name = "Ϸ "
		division = { experience = 10 id = { type = 13016 id = 415 }	name = "4޲ǹ "
				type = militia strength = 100 }	}

landunit = { location = 1299 id = { type = 13016 id = 418 }	name = " "
		division = { experience = 15 id = { type = 13016 id = 419 }	name = "1鲽ǹ "
				type = infantry	strength = 100 model = 0} }

landunit = { location = 1296 id = { type = 13016 id = 423 }	name = "ü "
		division = { experience = 15 id = { type = 13016 id = 420 }	name = "2鲽ǹ "
				type = infantry strength = 100 model = 0} }

landunit = { location = 1797 id = { type = 13016 id = 421 }	name = "˹̹-Լ "
		division = { experience = 35 id = { type = 13016 id = 61 }	name = "8Ħлʦ "
				type = motorized strength = 80
				extra = armored_car } }
navalunit = { 
	name = " "
	location = 5 
	base = 5
	id = { type = 13016 id = 500 }	
	division = { id = { type = 13016 id = 501 } name = "ɶѷ " type = battleship model = 2 }
	division = { id = { type = 13016 id = 502 } name = "޵ " type = battleship model = 2 }
	division = { id = { type = 13016 id = 503 } name = "ʼ " type = battleship model = 1 }
	division = { id = { type = 13016 id = 504 } name = "Ȩ " type = battleship model = 1 }
	division = { id = { type = 13016 id = 505 } name = "˹ " type = battleship model = 1 }
	division = { id = { type = 13016 id = 510 } name = "ŭ " type = carrier model = 1 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 526 } name = "ŵ˺ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 641 } name = "˺ "" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 515 } name = "ķ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 512 } name = "лƶº " type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 511 } name = "Ů " type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 577 } name = "˹ " type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 600 } name = "ú " type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 516 } name = " " type = light_cruiser model = 1 }
	division = { id = { type = 13016 id = 517 } name = "ҵ " type = light_cruiser model = 1 }
	division = { id = { type = 13016 id = 521 } name = "Ҷī˹ " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 524 } name = " " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 525 } name = "Ӷ " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 519 } name = "ӵķ " type = light_cruiser model = 0  }
	division = { id = { type = 13016 id = 520 } name = " " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 568 } name = "1֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 566 } name = "2֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 561 } name = "3֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 562 } name = "4֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 564 } name = "5֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 528 } name = "6֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 529 } name = "7֧ " type = destroyer model = 2 }
	division = { id = { type = 13016 id = 530 } name = "8֧ " type = destroyer model = 2 }
	division = { id = { type = 13016 id = 576 } name = "9֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 575 } name = "10֧ " type = destroyer model = 1 }
	}

navalunit = { 
	name = "սѲ󽢽 "
	location = 5 
	base = 5
	id = { type = 13016 id = 499 }	
	division = { id = { type = 13016 id = 506 } name = "º " type = battlecruiser model = 2 }
	division = { id = { type = 13016 id = 507 } name = " " type = battlecruiser model = 1 }
	division = { id = { type = 13016 id = 508 } name = " " type = battlecruiser model = 1 }
	division = { id = { type = 13016 id = 509 } name = "ʼҷۺ " type = carrier model = 2 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 527 } name = "Ŧ˹ " type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 513 } name = " " type = light_cruiser model = 3 }
	}

navalunit = {
	name = "Ԥ "
	id = { type = 13016 id = 560 }
	location = 5 #Scapa Flow
	base = 5
	division = { id = { type = 13016 id = 701 }  name = "۾˺ " type = carrier model = 0
						extra = cag brigade_model = 2 }
	division = { id = { type = 13016 id = 563 } name = "ɯŮ " type = battleship model = 1 }
	division = { id = { type = 13016 id = 565 } name = "¸Һ " type = battleship model = 1 }
	division = { id = { type = 13016 id = 567 } name = "ޱЪ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 569 } name = "˹ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 574 } name = "׶غ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 635 } name = " " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 640 } name = "ƺ " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 522 } name = " " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 518 } name = "ᶡ " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 523 } name = "ո " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 642 } name = "ֺ " type = light_cruiser model = 0 }
	}

navalunit = {
	name = "ڶǱͧ "
	id = { type = 13016 id = 531 }
	location = 5
	base = 5
	division = { id = { type = 13016 id = 532 } name = "5Ǳ֧ͧ " type = submarine model = 1 }
	division = { id = { type = 13016 id = 533 } name = "6Ǳ֧ͧ " type = submarine model = 1 }
	division = { id = { type = 13016 id = 534 } name = "7Ǳͧ " type = submarine model = 1 }
	}

navalunit = {
	name = "Ǳͧ "
	id = { type = 13016 id = 535 }
	location = 5
	base = 5
	division = { id = { type = 13016 id = 536 } name = "12Ǳ֧ͧ " type = submarine model = 1 }
	}

navalunit = {
	name = "һ佢 "
	id = { type = 13016 id = 537 }
	location = 21 #Portsmouth
	base = 21
	division = { id = { type = 13016 id = 538 } name = "1佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 539 } name = "2佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 5660 } name = "3佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 5661 } name = "4佢֧ " type = transport model = 0 }
	}

navalunit = {
	name = "Ͽ "
	id = { type = 13016 id = 540 }
	location = 21 #Portsmouth
	base = 21
	division = { id = { type = 13016 id = 541 } name = "ĺ " type = battleship model = 1 }
	division = { id = { type = 13016 id = 542 } name = " " type = battleship model = 1 }
	division = { id = { type = 13016 id = 543 } name = " " type = carrier model = 1 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 544 } name = "նī˹ " type = carrier model = 0 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 545 } name = "Ů " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 546 } name = "˺ " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 547 } name = "޺ " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 548 } name = "11֧ " type = destroyer model = 0 }
	division = { id = { type = 13016 id = 570 } name = "12֧ " type = destroyer model = 1 }
	}

navalunit = {
	name = "Ǳͧ "
	id = { type = 13106 id = 549 }
	location = 21 #Portsmouth
	base = 21
	division = { id = { type = 13016 id = 550 } name = "10Ǳ֧ͧ " type = submarine model = 1 }
	division = { id = { type = 13016 id = 551 } name = "11Ǳ֧ͧ " type = submarine model = 2 }
	}

navalunit = {
	name = "ڶ佢 "
	id = { type = 13016 id = 552 }
	location = 21 #Portsmouth
	base = 21
	division = { id = { type = 13016 id = 553 } name = "5佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 554 } name = "6佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 5662 } name = "7佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 5663 } name = "8佢֧ " type = transport model = 0 }
	}

navalunit = {
	name = "Ѳ߽ "
	id = { type = 13016 id = 5666 }
	location = 21 #Portsmouth
	base = 21
	division = { id = { type = 13016 id = 5667 } name = "ֲ " type = battleship model = 0 maxspeed = 10 							seaattack = 6 seadefence = 6 shorebombardment = 8 }
	division = { id = { type = 13016 id = 5668 } name = " " type = battleship model = 0 maxspeed = 10
							seaattack = 6 seadefence = 6 shorebombardment = 8 }
	}

navalunit = {
	name = " "
	id = { type = 13016 id = 555 }
	location = 13
	base = 13
	division = { id = { type = 13016 id = 514 } name = "˹غ " type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 556 } name = "ϰնغ " type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 557 } name = "˹ " type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 558 } name = "13֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 559 } name = "14֧ " type = destroyer model = 1 }
	}

navalunit = {
	name = "ʮ֧ "
	id = { type = 13016 id = 571 }
	location = 23 #Plymouth
	base = 23
	division = { id = { type = 13016 id = 572 } name = "15֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 573 } name = "16֧ " type = destroyer model = 0 }
	}

navalunit = {
	name = "к "
	id = { type = 13016 id = 579 }
	location = 906 #Alexandria
	base = 906
	division = { id = { type = 13016 id = 580 } name = "ս " type = battleship model = 1 }
	division = { id = { type = 13016 id = 581 } name = "ķ " type = battleship model = 1 }
	division = { id = { type = 13016 id = 582 } name = "Ǻ " type = battleship model = 1 }
	division = { id = { type = 13016 id = 583 } name = "ٺ " type = carrier model = 1 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 584 } name = "ĺ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 585 } name = "ʲպ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 586 } name = "˹ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 587 } name = "ˮ " type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 588 } name = " " type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 589 } name = "Ǻ " type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 590 } name = "Ĵ " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 591 } name = "17֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 592 } name = "18֧ " type = destroyer model = 0 }
	division = { id = { type = 13016 id = 593 } name = "19֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 594 } name = "20֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 595 } name = "21֧ " type = destroyer model = 0 }
	division = { id = { type = 13016 id = 596 } name = "22֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 597 } name = "23֧ " type = destroyer model = 1 }
}

navalunit = {
	name = "һǱͧ "
	id = { type = 13016 id = 598 }
	location = 906 #Alexandria
	base = 906
	division = { id = { type = 13016 id = 599 } name = "1Ǳ֧ͧ " type = submarine model = 2 }
	division = { id = { type = 13016 id = 903 } name = "2Ǳ֧ͧ " type = submarine model = 0 }
	division = { id = { type = 13016 id = 900 } name = "3Ǳ֧ͧ " type = submarine model = 2 }
	division = { id = { type = 13016 id = 902 } name = "4Ǳ֧ͧ " type = submarine model = 2 }
	}

navalunit = {
	name = "佢 "
	id = { type = 13016 id = 601 }
	location = 906 #Alexandria
	base = 906
	division = { id = { type = 13016 id = 602 } name = "9佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 603 } name = "10佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 5664 } name = "11佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 5665 } name = "12佢֧ " type = transport model = 0 }
	}

navalunit = {
	name = "佢 "
	id = { type = 13016 id = 9879 }
	location = 20 #Dover
	base = 20
	division = { id = { type = 13016 id = 9880 } name = "13佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 9881 } name = "14佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 9882 } name = "15佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 9883 } name = "16佢֧ " type = transport model = 0 }
	}

navalunit = {
	name = "佢 "
	id = { type = 13016 id = 9884 }
	location = 23 #Plymouth
	base = 23
	division = { id = { type = 13016 id = 9885 } name = "17佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 9886 } name = "18佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 9887 } name = "19佢֧ " type = transport model = 0 }
	division = { id = { type = 13016 id = 9888 } name = "20佢֧ " type = transport model = 0 }
	}

navalunit = {
	name = "˾ "
	id = { type = 13016 id = 604 }
	location = 348 #Gibraltar
	base = 348
	division = { id = { type = 13016 id = 605 } name = "ײ " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 606 } name = "նغ " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 607 } name = "24֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 608 } name = "25֧ " type = destroyer model = 1 }
	}

navalunit = {
	name = "ϴ˾ "
	id = { type = 13016 id = 609 }
	location = 988 #Freetown
	base = 988
	division = { id = { type = 13016 id = 610 } name = "նٺ " type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 613 } name = "ȶ " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 614 } name = "° " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 615 } name = "غ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 616 } name = "ֿ˹ " type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 617 } name = " " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 611 } name = "ǲ " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 612 } name = " " type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 578 } name = "26֧ " type = destroyer model = 0 }
	division = { id = { type = 13016 id = 618 } name = "27֧ " type = destroyer model = 0 }
	}

navalunit = {
	name = "޺ӡڰ "
	id = { type = 13016 id = 619 }
	location = 538 #Bermuda
	base = 538
	division = { id = { type = 13016 id = 620 } name = "˺ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 621 } name = "Ի " type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 622 } name = "Լ˺ " type = heavy_cruiser model = 1 }
	}

navalunit = {
	name = "й "
	id = { type = 13016 id = 623 }
	location = 1315 #Hong Kong
	base = 1315
	division = { id = { type = 13016 id = 624 } name = "ӥ " type = carrier model = 1 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 625 } name = "غ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 626 } name = "ֶ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 627 } name = " " type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 628 } name = "غ " type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 629 } name = "28֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 630 } name = "29֧ " type = destroyer model = 1 }
	division = { id = { type = 13016 id = 631 } name = "30֧ " type = destroyer model = 0 }
	}

navalunit = {
	name = "Ǳͧ "
	id = { type = 13016 id = 632 }
	location = 1315 #Hong Kong
	base = 1315
	division = { id = { type = 13016 id = 633 } name = "8Ǳ֧ͧ " type = submarine model = 2 }
	division = { id = { type = 13016 id = 634 } name = "9Ǳ֧ͧ " type = submarine model = 2 }
	}

navalunit = {
	name = "ӡȽ "
	id = { type = 13016 id = 636 }
	location = 1517 #Colombo
	base = 1517
	division = { id = { type = 13016 id = 637 } name = "˹غ " type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 639 } name = "˹غ " type = light_cruiser model = 3 }
	}

division_development = {
	name = "ֺ "
	type = light_cruiser
	model = 3
	cost = 4
	id = { type = 13016 id = 638 } 
	date = { year = 1938 month = october day = 25 }
	}

division_development = {
	name = " "
	type = battleship
	model = 3
	cost = 8.5
	id = { type = 13016 id = 800 }
	date = { year = 1939 month = january day = 1 }
	}

division_development = {
	name = "ʿӺ "
	type = battleship
	model = 3
	cost = 8.5
	id = { type = 13016 id = 801 }
	date = { year = 1939 month = april day = 1 }
	}

division_development = {
	name = "Լ˹ "
	type = battleship
	model = 3
	cost = 8.5
	id = { type = 13016 id = 812 }
	date = { year = 1939 month = may day = 5 }
	}

division_development = {
	name = "ɭ "
	type = battleship
	model = 3
	cost = 8.5
	id = { type = 13016 id = 813 }
	date = { year = 1939 month = july day = 20 }
	}

division_development = {
	name = " "
	type = battleship
	model = 3
	cost = 8.5
	id = { type = 13016 id = 814 }
	date = { year = 1939 month = june day = 1 }
	}

division_development = {
	name = "Ժ "
	type = carrier
	model = 3
	cost = 5.9
	id = { type = 13016 id = 802 }
	date = { year = 1939 month = april day = 27 }
	}

brigade_development = {
	name = "ԺCAG "
	type = cag
	model = 3
	cost = 3
	id = { type = 13016 id = 809 }
	date = { year = 1939 month = april day = 27 }
	}

division_development = {
	name = "ʤ "
	type = carrier
	model = 3
	cost = 5.9
	id = { type = 13016 id = 803 }
	date = { year = 1939 month = may day = 4 }
	}

brigade_development = {
	name = "ʤCAG "
	type = cag
	model = 3
	cost = 3
	id = { type = 13016 id = 810 }
	date = { year = 1939 month = may day = 4 }
	}

division_development = {
	name = "η "
	type = carrier
	model = 3
	cost = 5.9
	id = { type = 13016 id = 804 }
	date = { year = 1939 month = june day = 17 }
	}

brigade_development = {
	name = "ηCAG "
	type = cag
	model = 3
	cost = 3
	id = { type = 13016 id = 811 }
	date = { year = 1939 month = june day = 17 }
	}

division_development = {
	name = "Ӻ "
	type = carrier
	model = 3
	cost = 5.9
	id = { type = 13016 id = 815 }
	date = { year = 1939 month = november day = 10 }
	}

brigade_development = {
	name = "ӺCAG "
	type = cag
	model = 3
	cost = 3
	id = { type = 13016 id = 816 }
	date = { year = 1939 month = november day = 10 }
	}


airunit = {
		location = 17
		base = 17
	        id = { type = 13016 id = 170 }
		name = "һը "
			division = { experience = 20
	        	id = { type = 13016 id = 171 }
			name = "71սը "
			type = tactical_bomber
			model = 1
			strength = 100
			}
			division = { experience = 20
	        	id = { type = 13016 id = 191 }
			name = "75սը "
			type = tactical_bomber
			model = 1
			strength = 100
			}
			}



airunit = {
		location = 16
		base = 16
        	id = { type = 13016 id = 172 }
		name = "ڶը "
			division = { experience = 20
		        id = { type = 13016 id = 173 }
			name = "73սը "
			type = tactical_bomber
			model = 1
			strength = 100
			}
			division = { experience = 20
		        id = { type = 13016 id = 192 }
			name = "74սը "
			type = tactical_bomber
			model = 1
			strength = 100
			}
			}

airunit = {
		location = 17
		base = 17
	        id = { type = 13016 id = 174 }
		name = "ը "
			division = { experience = 20
	        	id = { type = 13016 id = 175 }
			name = "71սԺը "
			type = strategic_bomber
			model = 0
			strength = 5
			}
			}

airunit = {
		location = 14
		base = 14
	        id = { type = 13016 id = 193 }
		name = "ʮ庣˾ "
			division = { experience = 20
		        id = { type = 13016 id = 194 }
			name = "15ը "
			type = naval_bomber
			model = 0
			}
			}

airunit = {
		location = 20
		base = 20
	        id = { type = 13016 id = 195 }
		name = "ʮ˾ "
			division = { experience = 20
		        id = { type = 13016 id = 196 }
			name = "16ը "
			type = naval_bomber
			model = 0
			}
			}

airunit = {
		location = 5
	        base = 5
		id = { type = 13016 id = 197 }
		name = "ʮ˺˾ "
			division = { experience = 20
		        id = { type = 13016 id = 198 }
			name = "18ը "
			type = naval_bomber
			model = 0
			}
			}

airunit = {
		location = 17
		base = 17
		id = { type = 13016 id = 176 }
		name = "ĺը "
			division = { experience = 5
		        id = { type = 13016 id = 177 }
			name = "4սԺը "
			type = strategic_bomber
			model = 0
			strength = 5
			}
			}

	airunit = {
		location = 17
		base = 17
	        id = { type = 13016 id = 178 }
		name = "ը "
			division = { experience = 5
	        	id = { type = 13016 id = 179 }
			name = "5սը "
			type = tactical_bomber
			model = 1
			strength = 20
			}
			}

	airunit = {
		location = 20
		base = 20
        	id = { type = 13016 id = 180 }
		name = "ʮһս "
			division = { experience = 20
		        id = { type = 13016 id = 181 }
			name = "11ս "
			type = interceptor
			model = 1
			}
			}

	airunit = {
		location = 13
        	base = 13
		id = { type = 13016 id = 182 }
		name = "ʮս "
			division = { experience = 20
		        id = { type = 13016 id = 183 }
			name = "12ս "
			type = interceptor
			model = 1
			}
			}

	airunit = {
		location = 9
		base = 9
	        id = { type = 13016 id = 184 }
		name = "ʮս "
			division = { experience = 35
		        id = { type = 13016 id = 185 }
			name = "13ս "
			type = interceptor
			model = 1
			}
			}

	airunit = {
		location = 21
		base = 21
	        id = { type = 13016 id = 199 }
		name = "ʮս "
			division = { experience = 35
		        id = { type = 13016 id = 200 }
			name = "10ս "
			type = interceptor
			model = 1
			}
			}

	airunit = {
		location = 1866 # Bagdhad (Habbinaya)
		base = 1866
 	       	id = { type = 13016 id = 186 }
		name = "жվ˾ "
			division = { experience = 35
		        id = { type = 13016 id = 187 }
			name = "жսը "
			type = tactical_bomber
			model = 1
			}
			}

	airunit = {
		location = 1457
		base = 1457
        	id = { type = 13016 id = 188 }
		name = "ӡȿվ˾ "
			division = { experience = 35
		        id = { type = 13016 id = 189 }
			name = "ӡսը "
			type = tactical_bomber
			model = 1
			}
			}

airunit = {
	location = 1353 
        base = 1353
	id = { type = 13016 id = 190 }
	name = "Զվ˾ "
		division = { experience = 35
	        id = { type = 13016 id = 201 }
		name = "Զսը "
		type = tactical_bomber
		model = 1
		}
		}


}


